<?php
/*
 * Copyright (c) 2025 AltumCode (https://altumcode.com/)
 *
 * This software is licensed exclusively by AltumCode and is sold only via https://altumcode.com/.
 * Unauthorized distribution, modification, or use of this software without a valid license is not permitted and may be subject to applicable legal actions.
 *
 * 🌍 View all other existing AltumCode projects via https://altumcode.com/
 * 📧 Get in touch for support or general queries via https://altumcode.com/contact
 * 📤 Download the latest version via https://altumcode.com/downloads
 *
 * 🐦 X/Twitter: https://x.com/AltumCode
 * 📘 Facebook: https://facebook.com/altumcode
 * 📸 Instagram: https://instagram.com/altumcode
 */

return [
    'direction' => 'ltr',

    'global.submit' => 'Submit',
    'global.create' => 'Create',
    'global.delete' => 'Delete',
    'global.edit' => 'Edit',
    'global.view' => 'View',
    'global.duplicate' => 'Duplicate',
    'global.transfer' => 'Transfer',
    'global.reset' => 'Reset',
    'global.share' => 'Share',
    'global.share_via' => 'Share via %s',
    'global.cancel' => 'Cancel',
    'global.update' => 'Update',
    'global.enable' => 'Enable',
    'global.hidden' => 'Hidden',
    'global.login' => 'Login',
    'global.language' => 'Language',
    'global.choose_language' => 'Choose language',
    'global.choose_currency' => 'Choose currency',
    'global.theme_style' => 'Switch to %s (CMD/CTRL + I)',
    'global.theme_style_light' => 'Light',
    'global.theme_style_dark' => 'Dark',
    'global.close' => 'Close',
    'global.search' => 'Search',
    'global.no_data' => 'No data available',
    'global.na' => 'N/A',
    'global.unknown' => 'Unknown',
    'global.none' => 'None',
    'global.yes' => 'Yes',
    'global.no' => 'No',
    'global.status' => 'Status',
    'global.active' => 'Active',
    'global.disabled' => 'Disabled',
    'global.all' => 'All',
    'global.order' => 'Order',
    'global.statistics' => 'Statistics',
    'global.download' => 'Download',
    'global.download_as' => 'Download as %s',
    'global.export' => 'Export',
    'global.export_to' => 'Export to %s',
    'global.captcha_placeholder' => 'Captcha text',
    'global.loading' => 'Loading..',
    'global.view_more' => 'View more',
    'global.view_x_more' => 'View %s more..',
    'global.clipboard_copy' => 'Copy to clipboard',
    'global.clipboard_copied' => 'Copied!',
    'global.terms_and_conditions' => 'Terms and Conditions',
    'global.privacy_policy' => 'Privacy Policy',
    'global.delete_file' => 'Delete uploaded file',
    'global.remove_selected_file' => 'Remove selected file',
    'global.bulk_actions' => 'Bulk actions',
    'global.unlimited' => 'Unlimited',
    'global.duplicated' => 'Duplicated',
    'global.datetime' => 'Created on',
    'global.last_datetime' => 'Updated on',
    'global.datetime_tooltip' => 'Created on %s',
    'global.last_datetime_tooltip' => 'Updated on %s',
    'global.device' => 'Device',
    'global.device.desktop' => 'Desktop',
    'global.device.tablet' => 'Tablet',
    'global.device.mobile' => 'Mobile',
    'global.continent' => 'Continent',
    'global.continents' => 'Continents',
    'global.country' => 'Country',
    'global.countries' => 'Countries',
    'global.city' => 'City',
    'global.cities' => 'Cities',
    'global.os_name' => 'Operating system',
    'global.browser_name' => 'Browser',
    'global.browser_language' => 'Browser language',
    'global.ip' => 'IP',
    'global.name' => 'Name',
    'global.description' => 'Description',
    'global.title' => 'Title',
    'global.email' => 'Email',
    'global.email_placeholder' => 'hello@example.com',
    'global.password' => 'Password',
    'global.user' => 'User',
    'global.image' => 'Image',
    'global.icon' => 'Icon',
    'global.icon_placeholder' => 'fas fa-bolt',
    'global.icon_help' => '<a href="https://fontawesome.com/search?o=r&m=free" target="_blank">FontAwesome</a> icon class.',
    'global.url' => 'URL',
    'global.url_placeholder' => 'https://example.com/',
    'global.url_slug_placeholder' => 'example',
    'global.host' => 'Host',
    'global.host_placeholder' => 'example.com',
    'global.admin_impersonate_user_help' => 'Logged in as',
    'global.admin_impersonate_user_logout' => 'Exit',
    'global.spintax_help' => 'You can also use Spintax format, as such: <code>{Hi|Hey|Hello}</code> to randomize words or phrases.',
    'global.team_delegate_access_help' => 'Logged in as %1$s via %2$s team.',
    'global.team_delegate_access_logout' => 'Exit',
    'global.update_x' => 'Edit %s',
    'global.mb' => 'MB',
    'global.details' => 'Details',
    'global.type' => 'Type',
    'global.view_all' => 'View all',
    'global.select_all' => 'Select all',
    'global.deselect_all' => 'Deselect all',
    'global.show' => 'Show',
    'global.hide' => 'Hide',
    'global.chart_help' => 'Chart automatically refreshes every %1$s hours. Data from the last %2$s days.',
    'global.id' => 'Entry number (ID)',
    'global.variables' => 'You can use the following dynamic variables: %s.',
    'global.translate' => 'Translate',
    'global.scroll_top' => 'Scroll top',
    'global.scroll_bottom' => 'Scroll bottom',
    'global.no_chart_data' => 'No data available',
    'global.no_chart_data_help' => 'There is not enough data to generate a chart.',
    'global.image_error' => 'Image error',
    'global.spotlight.search_placeholder' => '🔎 Search & go to a page...',
    'global.spotlight.tooltip' => 'Spotlight search (CMD/CTRL + K)',
    'global.drag_and_drop' => 'Drag & drop to reorder',
    'global.crop' => 'Crop image',
    'global.crop_selection' => 'Crop selection',
    'global.no_crop' => 'Continue without cropping',
    'global.prefilled_dynamic_name' => '%1$s %2$s - %3$s, %4$s',
    'global.day_part_late_night' => 'Late Night',
    'global.day_part_early_morning' => 'Early Morning',
    'global.day_part_morning' => 'Morning',
    'global.day_part_afternoon' => 'Afternoon',
    'global.day_part_evening' => 'Evening',
    'global.day_part_night' => 'Night',

    'global.info_message.user_plan_is_expired' => 'Your current plan has expired and your access is now limited.',
    'global.info_message.plan_feature_no_access' => 'Your current plan does not allow you to access this feature.',
    'global.info_message.plan_upgrade' => 'Upgrade your plan 🔐',
    'global.info_message.plan_feature_limit' => 'Your have exceeded the limits of your current plan.',
    'global.info_message.plan_feature_limit_info' => '%1$s out of %2$s used <br /> %3$s remaining',
    'global.info_message.plan_feature_limit_month_info' => '%1$s out of %2$s used <br /> %3$s remaining this month',
    'global.info_message.team_no_access' => 'Your team access does not allow you to use this feature.',
    'global.info_message.team_limit' => 'Only the team owner can access this page.',

    'global.success_message.create1' => '%s has been successfully created.',
    'global.success_message.create2' => 'Successfully created.',
    'global.success_message.update1' => '%s has been successfully updated.',
    'global.success_message.update2' => 'Successfully updated.',
    'global.success_message.delete1' => '%s has been successfully deleted.',
    'global.success_message.delete2' => 'Successfully deleted.',

    'global.error_message.directory_not_writable' => 'Directory <strong>%s</strong> is not writable. Please set the CHMOD permissions so this folder can be written.',
    'global.error_message.file_not_writable' => 'File <strong>%s</strong> is not writable . Please set the CHMOD permissions so this file can be written.',
    'global.error_message.empty_fields' => 'You must fill all the required fields.',
    'global.error_message.empty_field' => 'This field is required, you must fill it.',
    'global.error_message.invalid_file_type' => 'You are not allowed to upload files of this type.',
    'global.error_message.file_upload' => 'Something happened while uploading the file and we could not process it.',
    'global.error_message.invalid_csrf_token' => 'The action could not be finished because the protector has expired, please try again.',
    'global.error_message.basic' => 'We could not perform this action.',
    'global.error_message.file_size_limit' => 'The uploaded file is too big, the maximum file size you are allowed to upload is %s MB.',
    'global.error_message.password_length' => 'The password must be between 6 and 64 characters.',
    'global.error_message.passwords_not_matching' => 'The entered passwords do not match.',
    'global.error_message.invalid_email' => 'The entered email is invalid.',
    'global.error_message.invalid_captcha' => 'The entered captcha code is invalid.',
    'global.error_message.function_required' => '<code>%s</code> is required, but your server does not have it enabled. Contact your server administrator.',
    'global.error_message.limit_try_again' => 'You reached the limit. Try again in %1$s %2$s.',

    'global.menu.logout' => 'Logout',
    'global.menu.admin' => 'Admin panel',

    'global.accessibility.toggle_navigation' => 'Toggle navigation',
    'global.accessibility.logo_alt' => 'Website logo',
    'global.accessibility.captcha_alt' => 'Captcha',
    'global.accessibility.captcha_input' => 'Captcha field',
    'global.accessibility.whitelisted_file_extensions' => '%s allowed.',
    'global.accessibility.file_size_limit' => '%s MB maximum.',
    'global.accessibility.admin_file_size_limit_help' => 'You are not able to set a higher limit than your actual server upload limit.',

    'global.pagination.previous' => 'Previous',
    'global.pagination.next' => 'Next',
    'global.pagination.results' => 'Showing %1$s-%2$s out of %3$s results.',

    'global.filters.tooltip' => 'Filters<br />(CMD/CTRL + SHIFT + F)',
    'global.filters.header' => 'Filters',
    'global.filters.reset' => 'Reset',
    'global.filters.clear' => 'Clear filters',
    'global.filters.search' => 'Search',
    'global.filters.search_by' => 'Search by',
    'global.filters.order_by' => 'Order by',
    'global.filters.order_by_datetime' => 'Created datetime',
    'global.filters.order_by_last_datetime' => 'Updated datetime',
    'global.filters.order_type' => 'Order type',
    'global.filters.order_type_asc' => 'Ascending',
    'global.filters.order_type_desc' => 'Descending',
    'global.filters.results_per_page' => 'Results per page',
    'global.filters.no_data' => 'No filtered data found',
    'global.filters.no_data_help' => 'No matches found for your filter.',

    'global.date.datetime_readable_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_readable_format' => '%1$s %2$s',
    'global.date.datetime_ymd_format' => '%1$s-%2$s-%3$s',
    'global.date.datetime_his_format' => '%1$s:%2$s:%3$s',
    'global.date.datetime_ymd_his_format' => '%1$s-%2$s-%3$s %4$s:%5$s:%6$s',
    'global.date.now' => 'now',
    'global.date.cancel' => 'Cancel',
    'global.date.apply' => 'Apply',
    'global.date.from' => 'From',
    'global.date.to' => 'To',
    'global.date.custom' => 'Custom',
    'global.date.today' => 'Today',
    'global.date.yesterday' => 'Yesterday',
    'global.date.last_7_days' => 'Last 7 days',
    'global.date.last_30_days' => 'Last 30 days',
    'global.date.this_month' => 'This month',
    'global.date.last_month' => 'Last month',
    'global.date.all_time' => 'All time',
    'global.date.short_milliseconds' => 'ms',
    'global.date.short_seconds' => 's',
    'global.date.second' => 'second',
    'global.date.seconds' => 'seconds',
    'global.date.minute' => 'minute',
    'global.date.minutes' => 'minutes',
    'global.date.hour' => 'hour',
    'global.date.hours' => 'hours',
    'global.date.day' => 'day',
    'global.date.days' => 'days',
    'global.date.week' => 'week',
    'global.date.weeks' => 'weeks',
    'global.date.month' => 'month',
    'global.date.months' => 'months',
    'global.date.year' => 'year',
    'global.date.years' => 'years',
    'global.date.time_ago' => '%1$s %2$s ago',
    'global.date.time_until' => '%1$s %2$s',

    'global.date.long_days.1' => 'Monday',
    'global.date.long_days.2' => 'Tuesday',
    'global.date.long_days.3' => 'Wednesday',
    'global.date.long_days.4' => 'Thursday',
    'global.date.long_days.5' => 'Friday',
    'global.date.long_days.6' => 'Saturday',
    'global.date.long_days.7' => 'Sunday',

    'global.date.short_days.1' => 'Mon',
    'global.date.short_days.2' => 'Tue',
    'global.date.short_days.3' => 'Wed',
    'global.date.short_days.4' => 'Thu',
    'global.date.short_days.5' => 'Fri',
    'global.date.short_days.6' => 'Sat',
    'global.date.short_days.7' => 'Sun',

    'global.date.long_months.1' => 'January',
    'global.date.long_months.2' => 'February',
    'global.date.long_months.3' => 'March',
    'global.date.long_months.4' => 'April',
    'global.date.long_months.5' => 'May',
    'global.date.long_months.6' => 'June',
    'global.date.long_months.7' => 'July',
    'global.date.long_months.8' => 'August',
    'global.date.long_months.9' => 'September',
    'global.date.long_months.10' => 'October',
    'global.date.long_months.11' => 'November',
    'global.date.long_months.12' => 'December',

    'global.date.short_months.1' => 'Jan',
    'global.date.short_months.2' => 'Feb',
    'global.date.short_months.3' => 'Mar',
    'global.date.short_months.4' => 'Apr',
    'global.date.short_months.5' => 'May',
    'global.date.short_months.6' => 'Jun',
    'global.date.short_months.7' => 'Jul',
    'global.date.short_months.8' => 'Aug',
    'global.date.short_months.9' => 'Sep',
    'global.date.short_months.10' => 'Oct',
    'global.date.short_months.11' => 'Nov',
    'global.date.short_months.12' => 'Dec',

    'global.number.decimal_point' => '.',
    'global.number.thousands_separator' => ',',

    'global.emails.copyright' => 'Copyright © %1$s %2$s.',
    'global.emails.anti_phishing_code' => 'Anti phishing code: %s',
    'global.emails.is_broadcast' => 'You are receiving this email because you have subscribed to our newsletter broadcasts. You can %sUnsubscribe here%s at any point in time.',

    'global.emails.user_welcome.subject' => 'Welcome to {{WEBSITE_TITLE}}',
    'global.emails.user_welcome.body' => 'Hello, <strong>{{NAME}}</strong>!<br /><br />Welcome to our website community, we\'re excited to have you on board!<br /><br />Get started by visiting our <a href="{{URL}}">homepage</a> or your <a href="{{DASHBOARD_LINK}}">dashboard</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_activation.subject' => 'Confirm your new account - {{WEBSITE_TITLE}}',
    'global.emails.user_activation.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />We are glad you joined us! <br /><br />One more step and your account is ready,<br /><br />Click the link below in order to join <strong>{{WEBSITE_TITLE}}</strong><br /><br /><a href="{{ACTIVATION_LINK}}" class="cta">Activate account</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_pending_email.subject' => 'Confirm your email address change - {{WEBSITE_TITLE}}',
    'global.emails.user_pending_email.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />You have requested to change your email address from {{CURRENT_EMAIL}} to {{NEW_EMAIL}}. <br /><br />Please click on the link below to confirm your new email address. <br /><br /><a href="{{ACTIVATION_LINK}}" class="cta">Confirm email address change</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_lost_password.subject' => 'Reset your password - {{WEBSITE_TITLE}}',
    'global.emails.user_lost_password.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is your reset password link:<br /><br /><a href="{{LOST_PASSWORD_LINK}}" class="cta">Reset password</a><br /><br />If you did not request this, you can ignore it.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_payment.subject' => 'Payment received - {{WEBSITE_TITLE}}',
    'global.emails.user_payment.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your payment has been received by us.<br /><br />You\'ve paid for the <strong>{{PLAN_NAME}}</strong> plan until <strong>{{PLAN_EXPIRATION_DATE}}</strong>.<br /><br />You can also check all the <a href="{{USER_PAYMENTS_LINK}}">payments</a> you made, <a href="{{USER_PLAN_LINK}}">change your plan</a> or <a href="{{USER_PLAN_LINK}}">cancel it</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_plan_expiry_reminder.subject' => 'Your plan is expiring in {{DAYS_UNTIL_EXPIRATION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expiry_reminder.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple reminder that your <strong>{{PLAN_NAME}} plan</strong> is going to expire in <strong>{{DAYS_UNTIL_EXPIRATION}} days</strong>.<br /><br />You must renew your plan if you wish to continue using our website with all the features you have.<br /><br /><a href="{{USER_PLAN_RENEW_LINK}}" class="cta">Renew plan</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_plan_expired.subject' => 'Your plan has expired - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expired.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />Your <strong>{{PLAN_NAME}} plan</strong> has expired as you haven\'t renewed your membership.<br /><br />If you wish to continue using our website with all the features you had, you will need to renew your membership.<br /><br /><a href="{{USER_PLAN_RENEW_LINK}}" class="cta">Renew plan</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_deletion_reminder.subject' => 'Your account will be deleted in {{DAYS_UNTIL_DELETION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_deletion_reminder.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your account is going to be deleted in {{DAYS_UNTIL_DELETION}} days because your account has been inactive.<br /><br />If you wish to cancel this deletion, simply login with your account and the deletion process will be stopped.<br /><br /><a href="{{LOGIN_LINK}}">Login & stop deletion</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.auto_delete_inactive_users.subject' => 'Your account has been deleted - {{WEBSITE_TITLE}}',
    'global.emails.auto_delete_inactive_users.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple email to let you know that your account has been deleted because of being inactive for more than {{INACTIVITY_DAYS}} days.<br /><br />If you wish to re-gain access, you would need to sign-up another account with us.<br /><br /><a href="{{REGISTER_LINK}}" class="cta">Register again</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_affiliate_withdrawal_approved.subject' => 'Affiliate withdrawal approved - {{WEBSITE_TITLE}}',
    'global.emails.user_affiliate_withdrawal_approved.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your recent affiliate withdrawal of <strong>{{AMOUNT}} {{CURRENCY}}</strong> has been approved and your payment was sent for processing.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.team_member_create.subject' => 'You\'ve been invited to \'{{TEAM:NAME}}\' team - {{WEBSITE_TITLE}}',
    'global.emails.team_member_create.body_login' => 'Hello,<br /><br />You have been invited by <strong>{{USER:NAME}}</strong> ({{USER:EMAIL}}) to join the <strong>{{TEAM:NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{LOGIN_LINK}}" class="cta">login and accept invitation</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',
    'global.emails.team_member_create.body_register' => 'Hello,<br /><br />You have been invited by <strong>{{USER:NAME}}</strong> ({{USER:EMAIL}}) to join the <strong>{{TEAM:NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{REGISTER_LINK}}" class="cta">register and accept invitation</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.admin_new_user_notification.subject' => 'New user registered - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_user_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) has signed up successfully.<br /><br /><strong>Source:</strong> {{SOURCE}}<br /><strong>IP:</strong> {{IP}}<br /><strong>Country:</strong> {{COUNTRY_NAME}}<br /><strong>City:</strong> {{CITY_NAME}}<br /><strong>Device:</strong> {{DEVICE_TYPE}}<br /><strong>OS:</strong> {{OS_NAME}}<br /><strong>Browser:</strong> {{BROWSER_NAME}}<br /><br /><a href="{{USER_LINK}}" class="cta">View user</a>',

    'global.emails.admin_delete_user_notification.subject' => 'User deleted his account - {{WEBSITE_TITLE}}',
    'global.emails.admin_delete_user_notification.body' => 'All data of <strong>{{NAME}}</strong> ({{EMAIL}}) has been deleted.<br /><br /><strong>Account age:</strong> {{ACCOUNT_AGE}}<br /><strong>Source:</strong> {{SOURCE}}<br /><strong>IP:</strong> {{IP}}<br /><strong>Country:</strong> {{COUNTRY_NAME}}<br /><strong>City:</strong> {{CITY_NAME}}<br /><strong>Device:</strong> {{DEVICE_TYPE}}<br /><strong>OS:</strong> {{OS_NAME}}<br /><strong>Browser:</strong> {{BROWSER_NAME}}<br /><br />All of the data related to this user has been deleted.',

    'global.emails.admin_new_payment_notification.subject' => 'New payment via {{PROCESSOR}} of {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_payment_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) just paid <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> for the <strong>{{PLAN_NAME}} plan</strong>.<br /><br /><strong>Type:</strong> {{PAYMENT_TYPE}}<br /><strong>Frequency:</strong> {{PAYMENT_FREQUENCY}}<br /><strong>Processor:</strong> {{PROCESSOR}}<br /><strong>Code:</strong> {{CODE}} (-{{DISCOUNT_AMOUNT}} {{CURRENCY}})<br /><strong>Payment ID:</strong> {{PAYMENT_ID}}<br /><strong>Processor payment ID:</strong> {{EXTERNAL_PAYMENT_ID}}<br /><strong>Status:</strong> {{PAYMENT_STATUS}}<br /><strong>Date:</strong> {{DATE}} {{DATE_TIMEZONE}}<br /><br /><a href="{{PAYMENT_LINK}}" class="cta">View payment</a>',

    'global.emails.admin_new_affiliate_withdrawal_notification.subject' => 'New affiliate withdrawal request for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_affiliate_withdrawal_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just submitted an affiliate withdrawal request for <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> with the following note: "{{AFFILIATE_WITHDRAWAL_NOTE}}".<br /><br /><a href="{{ADMIN_AFFILIATE_WITHDRAWAL_LINK}}" class="cta">View affiliate withdrawal</a>',

    'global.emails.admin_new_domain_notification.subject' => 'New custom domain is pending approval - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_domain_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user\'s custom domain ({{DOMAIN_HOST}}) is now pending approval.<br /><br /> <a href="{{ADMIN_DOMAIN_UPDATE_LINK}}" class="cta">View domain</a>',

    'global.emails.admin_contact.subject' => '{{SUBJECT}} - {{NAME}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_contact.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) has sent you the following message:<br /><br />{{MESSAGE}}',

    'global.emails.transfer_download.subject' => 'Someone downloaded \'{{TRANSFER_NAME}}\' - {{WEBSITE_TITLE}}',
    'global.emails.transfer_download.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />Someone has downloaded your <a href="{{TRANSFER_LINK}}"><strong>{{TRANSFER_NAME}}</strong></a> transfer.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.transfer_send.subject' => 'Someone sent you \'{{TRANSFER_NAME}}\' - {{WEBSITE_TITLE}}',
    'global.emails.transfer_send.body' => 'Hello, <br /><br />Someone has sent <strong>{{TRANSFER_TOTAL_FILES}}</strong> files of <strong>{{TRANSFER_TOTAL_SIZE}}</strong> to you with the following note "{{TRANSFER_DESCRIPTION}}".<br /><br />Download the <a href="{{TRANSFER_LINK}}"><strong>{{TRANSFER_NAME}}</strong></a> transfer.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',


    'global.notifications.new_user.title' => 'New user!',
    'global.notifications.new_user.description' => '<strong>%1$s</strong> (%2$s) has signed up successfully.',

    'global.notifications.delete_user.title' => 'User deleted!',
    'global.notifications.delete_user.description' => '<strong>%1$s</strong> (%2$s) has deleted his account.',

    'global.notifications.new_payment.title' => 'New payment!',
    'global.notifications.new_payment.description' => '<strong>%1$s</strong> (%2$s) user just paid <strong>%3$s %4$s</strong> via %5$s.',

    'global.notifications.new_affiliate_withdrawal.title' => 'New affiliate withdrawal request!',
    'global.notifications.new_affiliate_withdrawal.description' => '<strong>%1$s</strong> (%2$s) user just submitted an affiliate withdrawal request for <strong>%3$s %4$s</strong>.',

    'global.notifications.new_newsletter_subscriber.title' => 'New newsletter subscriber!',
    'global.notifications.new_newsletter_subscriber.description' => '<strong>%1$s</strong> (%2$s) has subscribed successfully.',


    'global.cookie_consent.menu' => 'Cookies',
    'global.cookie_consent.header' => 'We use cookies 🍪',
    'global.cookie_consent.subheader' => 'Hi, this website uses essential cookies to ensure its proper operation and tracking cookies to understand how you interact with it. The latter will be set only after consent.',
    'global.cookie_consent.modal.preferences.header' => 'Cookie preferences',
    'global.cookie_consent.modal.header' => 'Cookie usage 📢',
    'global.cookie_consent.modal.subheader' => 'We use cookies to ensure the basic functionalities of the website and to enhance your online experience. You can choose for each category to opt-in/out whenever you want. For more details relative to cookies and other sensitive data, please read the full <a href="%s" class="cc-link">privacy policy</a>.',
    'global.cookie_consent.modal.necessary.header' => 'Strictly necessary cookies',
    'global.cookie_consent.modal.necessary.subheader' => 'These cookies are essential for the proper functioning of my website. Without these cookies, the website would not work properly.',
    'global.cookie_consent.modal.analytics.header' => 'Performance and Analytics cookies',
    'global.cookie_consent.modal.analytics.subheader' => 'These cookies allow the website to remember the choices you have made in the past.',
    'global.cookie_consent.modal.targeting.header' => 'Advertisement and Targeting cookies',
    'global.cookie_consent.modal.targeting.subheader' => 'These cookies collect information about how you use the website, which pages you visited and which links you clicked on. All of the data is anonymized and cannot be used to identify you.',
    'global.cookie_consent.accept_all' => 'Accept all',
    'global.cookie_consent.reject_all' => 'Reject all',
    'global.cookie_consent.customize' => 'Customize',
    'global.cookie_consent.save' => 'Save settings',

    'global.footer.copyright' => 'Copyright &copy; %1$s %2$s.',

    'global.plan_settings.annual_price_savings' => 'You save %s by purchasing the annual plan',
    'global.plan_settings.api_is_enabled' => 'API access',
    'global.plan_settings.api_is_enabled_help' => 'Get access to use the REST API.',
    'global.plan_settings.white_labeling_is_enabled' => 'White labeling',
    'global.plan_settings.white_labeling_is_enabled_help' => 'White label your whole account title, logo, favicon and footer.',
    'global.plan_settings.affiliate_commission_percentage' => '%s affiliate percentage',
    'global.plan_settings.affiliate_commission_percentage_help' => 'The percentage amount that you can earn with the affiliate program.',
    'global.plan_settings.no_ads' => 'No ads',
    'global.plan_settings.no_ads_help' => 'No ads for everything related to your account and experience.',
    'global.plan_settings.export' => '%s export features',
    'global.plan_settings.teams_limit' => '%s teams',
    'global.plan_settings.team_members_limit' => '%s team members',
    'global.plan_settings.documents_per_month_limit' => '%s AI Documents <span class="small text-muted">/ month</span>',
    'global.plan_settings.words_per_month_limit' => '%s AI words <span class="small text-muted">/ month</span>',
    'global.plan_settings.images_api.dall_e_3' => 'Dall-E v3 API',
    'global.plan_settings.images_api.gpt_image_1' => 'GPT Image 1 API',
    'global.plan_settings.images_api.clipdrop' => 'StableDiffusion API',
    'global.plan_settings.images_per_month_limit' => '%s AI images <span class="small text-muted">/ month</span>',
    'global.plan_settings.upscaled_images_per_month_limit' => '%s AI upscaled images <span class="small text-muted">/ month</span>',
    'global.plan_settings.removed_background_images_per_month_limit' => '%s AI removed bg. images <span class="small text-muted">/ month</span>',
    'global.plan_settings.replaced_background_images_per_month_limit' => '%s AI replaced bg. images <span class="small text-muted">/ month</span>',
    'global.plan_settings.transcriptions_per_month_limit' => '%s AI transcriptions <span class="small text-muted">/ month</span>',
    'global.plan_settings.transcriptions_file_size_limit' => '%s audio files transcriptions',
    'global.plan_settings.chats_per_month_limit' => '%s AI chats <span class="small text-muted">/ month</span>',
    'global.plan_settings.chat_messages_per_chat_limit' => '%s AI chats messages <span class="small text-muted">/ chat</span>',
    'global.plan_settings.syntheses_api.aws_polly' => 'AWS Polly API',
    'global.plan_settings.syntheses_api.openai_audio' => 'OpenAI Audio API',
    'global.plan_settings.syntheses_per_month_limit' => '%s AI syntheses <span class="small text-muted">/ month</span>',
    'global.plan_settings.synthesized_characters_per_month_limit' => '%s AI synthesized characters <span class="small text-muted">/ month</span>',
    'global.plan_settings.projects_limit' => '%s projects',


    'pwa_install.header' => 'Install our app 🪄',
    'pwa_install.or' => 'or',
    'pwa_install.subheader.desktop' => 'click on the <code>%s</code> icon in the top right of the address bar.',
    'pwa_install.subheader.android_chrome' => 'tap on the <code>%s</code> menu and then tap the <code>%s Add to Home screen</code> menu item.',
    'pwa_install.subheader.ios' => 'tap on the <code>%s</code> icon and then tap the <code>%s Add to Home Screen</code> menu item.',
    'pwa_install.subheader.ios_safari' => 'click on the <code>File > Add to Dock</code> menu item of the browser.',


    'push_notifications_modal.menu' => 'Push notifications',
    'push_notifications_modal.header' => 'Push notifications',
    'push_notifications_modal.subheader' => 'You can subscribe to our web push notifications if you want to receive helpful content and non-spam promotions from us.',
    'push_notifications_modal.subscribe' => 'Subscribe',
    'push_notifications_modal.unsubscribe' => 'Unsubscribe',
    'push_notifications_modal.denied' => 'You have denied or disabled push notifications. You must enable them again from the browser settings in order to be able to subscribe.',
    'push_notifications_modal.incompatible' => 'Your browser window is incompatible with receiving push notifications.',


    'ad_blocker_detector_modal.header' => 'Ad blocker detected',
    'ad_blocker_detector_modal.subheader' => 'We serve ads so we can keep our website running. Please disable your ad blockers.',
    'ad_blocker_detector_modal.button' => 'I\'ve disabled the ad blocker',


    'duplicate_modal.header' => 'Duplicate',
    'duplicate_modal.subheader' => 'Easily duplicate this resource with a click of a button.',


    'delete_modal.header' => 'Delete',
    'delete_modal.subheader1' => 'Deleting <strong>%s</strong> cannot be undone.',
    'delete_modal.subheader2' => 'Deleting this cannot be undone.',


    'transfer_modal.header' => 'Transfer ownership',
    'transfer_modal.subheader1' => 'Transfer <strong>%s</strong> to another user account.',
    'transfer_modal.subheader2' => 'Transfer this resource to another user account.',
    'transfer_modal.success_message' => 'The ownership of %1$s has been transferred from %2$s to %3$s',


    'statistics_reset_modal.header' => 'Clear statistics',
    'statistics_reset_modal.subheader' => 'Clear the current selected statistics. This action cannot be undone.',

    'x_reset_modal.header' => 'Reset',
    'x_reset_modal.subheader' => 'Reset the state of the resource and clear all it\'s associated logs or statistics. This action cannot be undone.',


    'bulk_download_modal.header' => 'Download in bulk',
    'bulk_download_modal.subheader' => 'You\'ve selected multiple entries to be downloaded, this may take a while for the ZIP to be generated.',


    'bulk_delete_modal.header' => 'Delete in bulk',
    'bulk_delete_modal.subheader' => 'You\'ve selected multiple entries to be deleted, this may take a while & it action cannot be undone.',
    'bulk_delete_modal.success_message' => 'The bulk deletion process was performed successfully.',


    'projects.title' => 'Projects',
    'projects.menu' => 'Projects',
    'projects.breadcrumb' => 'Projects',
    'projects.header' => 'Projects',
    'projects.subheader' => 'The easiest way to categorize your resources.',
    'projects.create' => 'Create project',
    'projects.project_id' => 'Project',
    'projects.project_id_help' => 'A project will help you categorize your resources.',
    'projects.color' => 'Color',
    'projects.color_help' => 'The color is used to help differentiate projects.',
    'projects.no_data' => 'There are no projects for now',
    'projects.no_data_help' => 'Start by creating your first project.',


    'project_create.breadcrumb' => 'Create a new project',
    'project_create.title' => 'Create a new project',
    'project_create.header' => 'Create a new project',


    'project_update.breadcrumb' => 'Edit project',
    'project_update.title' => 'Edit project',
    'project_update.header' => 'Edit project',


    'page.breadcrumb' => 'Page',
    'page.print' => 'Print',
    'page.estimated_reading_time' => '%s read',
    'page.total_views' => '%s views',


    'pages.title' => 'Pages',
    'pages.header' => 'Resources center',
    'pages.subheader' => 'Here you can find useful page resources depending on your needs.',
    'pages.index.breadcrumb' => 'Pages',
    'pages.index.popular_pages' => 'Popular pages',
    'pages.index.pages_categories.header' => 'Categories',
    'pages.index.pages_categories.total_pages' => '%s available pages',
    'pages.pages_category.breadcrumb' => 'Pages category',
    'pages.no_data' => 'There are resources yet',
    'pages.no_data_help' => 'We still got some work to do for our resources section',


    'blog.title' => 'Blog',
    'blog.title_search' => 'Search for \'%s\' - Blog',
    'blog.breadcrumb' => 'Blog',
    'blog.menu' => 'Blog',
    'blog.header' => 'Blog',
    'blog.header_search' => 'Blog - Search for \'%s\'',
    'blog.subheader' => 'Discover insights through our curated blog posts.',
    'blog.rss' => 'RSS Feed',
    'blog.categories' => 'Categories',
    'blog.popular' => 'Popular posts',
    'blog.total_views' => '%s views',
    'blog.estimated_reading_time' => '%s read',
    'blog.blog_post.title' => '%s - Blog',
    'blog.blog_posts_category.title' => '%s - Category - Blog',
    'blog.rating' => '%1$s of %2$s ratings',
    'blog.no_data' => 'There are no blog posts yet',
    'blog.no_data_help' => 'We still got some writing to do for our blog post',


    'plan.breadcrumb' => 'Choose plan',
    'plan.title' => 'Plan',
    'plan.menu' => 'Pricing',
    'plan.header_new' => 'Choose your plan',
    'plan.subheader_new' => 'Select the most convenient plan for you.',
    'plan.header_renew' => 'Renew or change your plan',
    'plan.subheader_renew' => 'Select one plan to renew or change your subscription.',
    'plan.header_upgrade' => 'Upgrade your plan',
    'plan.subheader_upgrade' => 'Select one package to upgrade your subscription.',

    'plan.custom_plan.monthly' => 'Monthly',
    'plan.custom_plan.quarterly' => 'Quarterly',
    'plan.custom_plan.biannual' => 'Biannual',
    'plan.custom_plan.annual' => 'Annual',
    'plan.custom_plan.lifetime' => 'Lifetime',

    'plans.choose' => 'Choose plan',
    'plans.renew' => 'Renew plan',
    'plans.trial' => 'Try for %s days',
    'plans.contact' => 'Contact us',
    'plans.lifetime' => 'Lifetime',

    'plan.why.header' => 'Why us?',
    'plan.why.one.header' => 'Customer service',
    'plan.why.one.subheader' => 'Our support team will help you with any questions you may have regarding our service.',
    'plan.why.two.header' => 'Privacy',
    'plan.why.two.subheader' => 'You control all the data that you bring within your account on our website.',
    'plan.why.three.header' => 'Quality',
    'plan.why.three.subheader' => 'We focus on delivering the best experience to you, as we fully understand how valuable time is.',

    'plan.faq.header' => 'Frequently asked questions',
    'plan.faq.one.question' => 'What forms of payment do you accept?',
    'plan.faq.one.answer' => 'We accept payments via credit cards, PayPal & crypto as well.',
    'plan.faq.two.question' => 'Can I cancel my subscription?',
    'plan.faq.two.answer' => 'Yes, you definitely can cancel your subscription and, you will still have access to all the features that you already paid for until the end of paid date range.',
    'plan.faq.three.question' => 'Will I get an invoice?',
    'plan.faq.three.answer' => 'Yes, an invoice will be automatically generated for you after any payments from your account.',
    'plan.faq.four.question' => 'Can I have a refund?',
    'plan.faq.four.answer' => 'We do offer refunds in case something goes wrong or you change your mind, simply contact us if needed.',


    'pay_billing.breadcrumb' => 'Billing',
    'pay_billing.title' => 'Billing',
    'pay_billing.header' => 'Fill in your billing details',
    'pay_billing.subheader' => 'We require your billing details for generating proper invoices & for tax handling, provide valid billing details only.',
    'pay_billing.submit' => 'Update & continue to %s checkout',

    'pay.breadcrumb' => '%s plan',
    'pay.title' => 'Pay - %s',
    'pay.attention_title' => '✨Checkout ready 🔥',
    'pay.plan_details' => 'What you\'ll get',
    'pay.accept' => 'By continuing with your order you confirm that you read, understand & agree to the %1$s and %2$s of the site.',

    'pay.free.free_already' => 'You already have the free plan activated.',
    'pay.free.other_plan_not_expired' => 'Your current plan is not expired yet, you will get the free plan after it expires.',

    'pay.trial.header' => 'Start the %s plan',
    'pay.trial.subheader' => 'You are almost there, no strings attached.',
    'pay.trial.trial_start' => 'Start my %s days trial',
    'pay.trial.trial_skip' => 'Skip trial',

    'pay.custom_plan.header' => 'Purchase the %s plan',
    'pay.custom_plan.subheader' => 'You are almost there, complete the following form and checkout.',
    'pay.custom_plan.paypal' => 'PayPal',
    'pay.custom_plan.stripe' => 'Stripe',
    'pay.custom_plan.offline_payment' => 'Offline payment',
    'pay.custom_plan.coinbase' => 'Coinbase',
    'pay.custom_plan.payu' => 'PayU',
    'pay.custom_plan.iyzico' => 'Iyzico',
    'pay.custom_plan.paystack' => 'Paystack',
    'pay.custom_plan.razorpay' => 'Razorpay',
    'pay.custom_plan.mollie' => 'Mollie',
    'pay.custom_plan.yookassa' => 'Yookassa',
    'pay.custom_plan.crypto_com' => 'Crypto.com',
    'pay.custom_plan.paddle' => 'Paddle',
    'pay.custom_plan.mercadopago' => 'MercadoPago',
    'pay.custom_plan.midtrans' => 'Midtrans',
    'pay.custom_plan.flutterwave' => 'Flutterwave',
    'pay.custom_plan.lemonsqueezy' => 'Lemonsqueezy',
    'pay.custom_plan.myfatoorah' => 'Myfatoorah',
    'pay.custom_plan.payment_frequency' => 'Payment frequency',
    'pay.custom_plan.monthly' => 'Monthly payments',
    'pay.custom_plan.quarterly' => 'Quarterly payments',
    'pay.custom_plan.biannual' => 'Biannual payments',
    'pay.custom_plan.annual' => 'Annual payments',
    'pay.custom_plan.annual_savings' => '%1$s %2$s',
    'pay.custom_plan.lifetime' => 'Lifetime deal',
    'pay.custom_plan.lifetime_help' => 'One time payment',
    'pay.custom_plan.code_button' => 'Use discount code',
    'pay.custom_plan.code' => 'Code',
    'pay.custom_plan.payment_processor' => 'Payment method',
    'pay.custom_plan.no_processor' => 'There are no payment processors available at the moment.',
    'pay.custom_plan.offline_payment_instructions' => 'Payment instructions',
    'pay.custom_plan.offline_payment_proof' => 'Proof of payment',
    'pay.custom_plan.payment_type' => 'Type of payment',
    'pay.custom_plan.one_time_type' => 'One time payment',
    'pay.custom_plan.recurring_type' => 'Recurring payment',

    'pay.custom_plan.summary.header' => 'Order summary',
    'pay.custom_plan.summary.plan' => 'Plan',
    'pay.custom_plan.summary.payment_frequency' => 'Frequency',
    'pay.custom_plan.summary.monthly' => 'Monthly',
    'pay.custom_plan.summary.monthly_help' => 'Every 30 days',
    'pay.custom_plan.summary.quarterly' => 'Quarterly',
    'pay.custom_plan.summary.quarterly_help' => 'Every 90 days',
    'pay.custom_plan.summary.biannual' => 'Biannual',
    'pay.custom_plan.summary.biannual_help' => 'Every 180 days',
    'pay.custom_plan.summary.annual' => 'Yearly',
    'pay.custom_plan.summary.annual_help' => 'Every 365 days',
    'pay.custom_plan.summary.lifetime' => 'Lifetime',
    'pay.custom_plan.summary.lifetime_help' => '',
    'pay.custom_plan.summary.payment_processor' => 'Paid with',
    'pay.custom_plan.summary.payment_type' => 'Type',
    'pay.custom_plan.summary.one_time' => 'One time',
    'pay.custom_plan.summary.one_time_help' => '',
    'pay.custom_plan.summary.recurring' => 'Recurring',
    'pay.custom_plan.summary.recurring_help' => 'Automatic billing',
    'pay.custom_plan.summary.plan_price' => 'Price',
    'pay.custom_plan.summary.discount' => 'Discount',
    'pay.custom_plan.summary.tax_inclusive' => 'Inclusive',
    'pay.custom_plan.summary.tax_exclusive' => 'Exclusive',
    'pay.custom_plan.summary.total' => 'Total',
    'pay.custom_plan.pay' => 'Checkout',
    'pay.custom_plan.code_redeemable' => 'Redeem %s days for free.',

    'pay.success_message.code' => 'Applied code for %s.',

    'pay.error_message.code_invalid' => 'This code is invalid.',
    'pay.error_message.code_used' => 'You have already used this code.',
    'pay.error_message.canceled_payment' => 'It seems you\'ve canceled the payment for some reason.',
    'pay.error_message.failed_payment' => 'Something didn\'t work quite right, please try again and if this persists contact the site admin.',
    'pay.error_message.offline_payment_proof_missing' => 'You must upload a payment proof before submitting the payment order.',

    'pay_thank_you.title' => 'Thank you',
    'pay_thank_you.header' => 'Thank you!',
    'pay_thank_you.button' => 'Go to my dashboard',
    'pay_thank_you.plan_trial_start' => 'Your %s day trial period just started!',
    'pay_thank_you.plan_redeemed' => 'You redeemed %s days!',
    'pay_thank_you.plan_custom_will_start' => 'Your payment was sent and your new membership will be activated!',
    'pay_thank_you.plan_custom_pending' => 'Your payment order was sent and your new membership will be activated if the proof will be accepted!',

    'account.title' => 'Account',
    'account.menu' => 'Account',

    'account.plan.header' => '%s plan',
    'account.plan.subheader' => 'ends on %s',
    'account.plan.upgrade_plan' => 'Upgrade plan',
    'account.plan.renew_plan' => 'Renew or change plan',

    'account.settings.header' => 'Settings',
    'account.settings.subheader' => 'Main settings of your account.',
    'account.settings.avatar' => 'Avatar',
    'account.settings.timezone' => 'Timezone',
    'account.settings.timezone_help' => 'Your preferred way of displaying dates.',
    'account.settings.anti_phishing_code' => 'Anti phishing code',
    'account.settings.anti_phishing_code_help' => 'You\'ll get this code on each email that we send you, so you\'ll know it\'s a valid email from us.',
    'account.settings.is_newsletter_subscribed' => 'Newsletter subscribed',
    'account.settings.is_newsletter_subscribed_help' => 'Receive a few emails per month with updates & discount campaigns we may run. We won\'t spam you.',
    'account.settings.referral_key' => 'Referral key',

    'account.billing.header' => 'Billing details',
    'account.billing.subheader' => 'These billing details are used when generating invoices after a successful payment.',
    'account.billing.subscription_id_active' => 'You have an active subscription, you can\'t change the billing details until the subscription expires or is cancelled.',
    'account.billing.type' => 'Type',
    'account.billing.type_personal' => 'Personal',
    'account.billing.type_business' => 'Business',
    'account.billing.name' => 'Name',
    'account.billing.address' => 'Address',
    'account.billing.county' => 'County',
    'account.billing.zip' => 'ZIP',
    'account.billing.phone' => 'Phone',
    'account.billing.tax_id' => 'Tax ID',
    'account.billing.notes' => 'Additional notes',
    'account.billing.notes_help' => 'Here you can write additional data that you want to have on your invoices.',

    'account.change_password.header' => 'Change password',
    'account.change_password.subheader' => 'If you do not want to change your password, do not fill any of those fields below.',
    'account.change_password.current_password' => 'Current password',
    'account.change_password.current_password_help' => 'If you do not know your current password, you mut logout and use the lost password functionality to reset it.',
    'account.change_password.new_password' => 'New password',
    'account.change_password.repeat_password' => 'Repeat password',

    'account.twofa.header' => 'Two-factor authentication',
    'account.twofa.subheader' => 'Use a mobile authentication app to get a verification code to enter every time you log in.',
    'account.twofa.is_enabled' => 'Enable Two-factor authentication',
    'account.twofa.qr' => '1. Scan QR Code',
    'account.twofa.qr_help' => 'Open your authentication app (ex: Authy, Google Authenticator) on your mobile device and scan the QR code using your camera.',
    'account.twofa.secret' => 'Can\'t scan the QR Code?',
    'account.twofa.secret_help' => 'Copy the following secret code into your app for a manual setup.',
    'account.twofa.verify' => '2. Enter freshly generated token',
    'account.twofa.verify_help' => 'To confirm that you setup your code properly, enter the 6-digit token from your mobile app.',

    'account.info_message.user_pending_email' => 'An email confirmation was sent to the new email address. Make sure to check and confirm it via email.',
    'account.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account.error_message.twofa_check' => 'The token that you entered is not valid.',
    'account.error_message.referral_key_exists' => 'This referral key is already in use.',
    'account.success_message.account_updated' => 'Your account was updated.',
    'account.success_message.password_updated' => 'Your account password was updated.',


    'account_preferences.title' => 'Preferences',
    'account_preferences.menu' => 'Preferences',
    'account_preferences.header' => 'Preferences',
    'account_preferences.subheader' => 'Here you can set different preferences for your account related to the site usage.',
    'account_preferences.success_message' => 'Your account preferences have been updated.',
    'account_preferences.avatar' => 'Avatar',
    'account_preferences.tracking_settings' => 'Tracking settings',
    'account_preferences.excluded_ips' => 'Excluded IPs',
    'account_preferences.excluded_ips_help' => 'Exclude IPs from being tracked. Comma separated values.',
    'account_preferences.default_settings' => 'Default settings',
    'account_preferences.default_results_per_page' => 'Default results per page',
    'account_preferences.default_order_type' => 'Default results order',
    'account_preferences.default_order_by_x' => '%s default order by',
    'account_preferences.white_labeling' => 'White labeling settings',
    'account_preferences.white_label_title' => 'White label title',
    'account_preferences.white_label_logo_light' => 'White label logo light',
    'account_preferences.white_label_logo_dark' => 'White label logo dark',
    'account_preferences.white_label_favicon' => 'White label favicon',
    'account_preferences.aix.optional_help' => 'Leave empty if you wish to use the system provided API key.',
    'account_preferences.aix.required_help' => 'You are required to add the API key, otherwise the AI related features will not work.',
    'account_preferences.aix.openai_api_key' => 'OpenAI - API Key',
    'account_preferences.aix.openai_api_key_help' => 'You can insert multiple OpenAI API Keys per line and the system will randomly choose one on each request.',
    'account_preferences.aix.clipdrop_api_key' => 'ClipDrop - API Key',
    'account_preferences.aix.clipdrop_api_key_help' => 'You can insert multiple ClipDrop API Keys per line and the system will randomly choose one on each request.',
    'account_preferences.aws_access_key' => 'AWS - Access key',
    'account_preferences.aws_secret_access_key' => 'AWS - Secret access key',
    'account_preferences.aws_region' => 'AWS - Region',
    'account_preferences.error_message.aix.openai_api_key' => 'You must insert your personal OpenAI Key to use this feature. Go to %s.',
    'account_preferences.error_message.aix.clipdrop_api_key' => 'You must insert your personal ClipDrop API Key to use this feature. Go to %s.',
    'account_preferences.error_message.aix.aws_api_keys' => 'You must insert your personal AWS API Keys to use this feature. Go to %s.',


    'account_delete.title' => 'Delete account',
    'account_delete.menu' => 'Delete account',
    'account_delete.header' => 'Delete account',
    'account_delete.subheader' => 'By deleting the account, all of your stored data will be deleted. This action is irreversible once done.',
    'account_delete.current_password' => 'Current Password',
    'account_delete.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account_delete.success_message' => 'Your account was fully deleted. We\'re sorry to see you go.',


    'account_redeem_code.title' => 'Redeem code',
    'account_redeem_code.menu' => 'Redeem code',
    'account_redeem_code.header' => 'Redeem code',
    'account_redeem_code.subheader' => 'If you own a redeeming code for a particular plan, you can redeem it right here.',
    'account_redeem_code.plan_id' => 'Plan',
    'account_redeem_code.code' => 'Code',
    'account_redeem_code.success_message' => 'You redeemed %1$s days of the %2$s plan.',
    'account_redeem_code.success_message_lifetime' => 'You redeemed the %2$s plan for lifetime.',
    'account_redeem_code.info_message' => 'Your current plan will be overwritten if you redeem a code that is different than your already existing plan.',
    'account_redeem_code.error_message.code_invalid' => 'This code is invalid.',
    'account_redeem_code.error_message.code_used' => 'You have already used this code.',


    'account_plan.title' => 'Account Plan',
    'account_plan.menu' => 'Plan',
    'account_plan.header' => 'Account Plan',

    'account_plan.plan.renews' => 'Plan will renew on %1$s via %2$s (%3$s %4$s)',
    'account_plan.plan.expires' => 'Plan ends on %s',
    'account_plan.plan.lifetime' => 'Plan is for lifetime, it does not expire.',

    'account_plan.cancel.header' => 'Cancel subscription',
    'account_plan.cancel.subheader' => 'By cancelling your subscription no further payments will be made. You will still have access to your features that you paid for until the expiration date.',
    'account_plan.cancel.cancel' => 'Cancel subscription',
    'account_plan.cancel.confirm_message' => 'Are you sure you want to cancel your subscription?',
    'account_plan.cancel.reason' => 'Cancelled from %s',

    'account_plan.success_message.subscription_canceled' => 'Your recurring subscription was canceled.',

    'account_payments.title' => 'Account payments',
    'account_payments.menu' => 'Payments',
    'account_payments.header' => 'Account payments',
    'account_payments.subheader' => 'All the payments made on your account.',

    'account_payments.payment_processor' => 'Processor',
    'account_payments.total_amount' => 'Total amount',
    'account_payments.plan_id' => 'Plan',
    'account_payments.invoice' => 'Invoice',
    'account_payments.status_pending' => 'Pending',
    'account_payments.status_approved' => 'Approved',
    'account_payments.no_data' => 'No payments found',

    'account_payments.processor' => 'Processor',
    'account_payments.type_one_time' => 'One time',
    'account_payments.type_recurring' => 'Recurring',
    'account_payments.frequency' => 'Frequency',
    'account_payments.order_by_total_amount' => 'Total amount',

    'account_logs.title' => 'Account logs',
    'account_logs.menu' => 'Logs',
    'account_logs.header' => 'Account logs',
    'account_logs.subheader' => 'A list of your most important recorded activity.',

    'account_logs.logs.no_data' => 'Your account has no recorded logs',
    'account_logs.logs.no_data_help' => 'Here you will be able to find important log entries regarding your account.',


    'account_api.title' => 'Account API',
    'account_api.menu' => 'API',
    'account_api.header' => 'API',
    'account_api.subheader' => 'Do not share your API key with unauthorized people.',
    'account_api.api_key' => 'API Key',
    'account_api.button' => 'Regenerate API Key',
    'account_api.success_message' => 'Your API key was regenerated successfully.',


    'teams_system.title' => 'Teams system',
    'teams_system.menu' => 'Teams',
    'teams_system.breadcrumb' => 'Teams system',
    'teams_system.header' => 'Teams system',


    'teams.title' => 'My teams',
    'teams.menu' => 'My teams',
    'teams.breadcrumb' => 'My teams',
    'teams.header' => ' My teams',
    'teams.subheader' => 'Create, invite and manage your teams.',
    'teams.create' => 'Create team',
    'teams.table.members' => 'Members',
    'teams.team' => 'Team',
    'teams.no_data' => 'There are no teams available',
    'teams.no_data_help' => 'Start by creating your first team & invite people.',


    'team.breadcrumb' => 'Team',
    'team.title' => 'Team - %s',
    'team.header' => '%s team',


    'team_create.breadcrumb' => 'Create team',
    'team_create.title' => 'Create team',
    'team_create.header' => 'Create team',


    'team_update.breadcrumb' => 'Update team',
    'team_update.title' => 'Update team',
    'team_update.header' => 'Update team',


    'team_members.create' => 'Invite member',
    'team_members.access' => '%s permissions',
    'team_members.access_help' => 'Set what permissions you want to hand out to the user.',
    'team_members.access.read' => 'View',
    'team_members.access.create' => 'Create',
    'team_members.access.update' => 'Update',
    'team_members.access.delete' => 'Delete',
    'team_members.table.member' => 'Member',
    'team_members.table.status_invited' => 'Invited',
    'team_members.table.status_accepted' => 'Accepted',
    'team_members.table.datetime' => 'Invited',
    'team_members.info_message.access' => 'The invited user will not have access to any account related pages, such as the account settings, payments, logs...etc.',
    'team_members.error_message.email_exists' => 'This email is already invited.',
    'team_members.no_data' => 'There are no team members available',
    'team_members.no_data_help' => 'Start by inviting your first member.',


    'team_member_create.breadcrumb' => 'Invite team member',
    'team_member_create.title' => 'Invite team member - %s',
    'team_member_create.header' => 'Invite team member',
    'team_member_create.submit' => 'Invite via Email',
    'team_member_create.success_message' => '%s has been successfully invited.',


    'team_member_update.breadcrumb' => 'Update team member',
    'team_member_update.title' => 'Update team member - %s',
    'team_member_update.header' => 'Update team member',


    'teams_member.title' => 'Teams\' member',
    'teams_member.menu' => 'Teams\' member',
    'teams_member.breadcrumb' => 'Teams\' member',
    'teams_member.header' => ' Teams member',
    'teams_member.subheader' => 'Manage the teams you\'re invited / a member of.',
    'teams_member.table.team' => 'Team',
    'teams_member.table.datetime' => 'Invited',
    'teams_member.no_data' => 'There are no teams available',
    'teams_member.no_data_help' => 'You\'re not invited to any team yet.',


    'teams_member_delete_modal.header' => 'Leave team',
    'teams_member_delete_modal.subheader' => 'This action cannot be undone.',


    'teams_member_join_modal.menu' => 'Join team',
    'teams_member_join_modal.header' => 'Join team',
    'teams_member_join_modal.subheader' => 'Accept & join the invitation of the team.',


    'teams_member_login_modal.menu' => 'Login',
    'teams_member_login_modal.header' => 'Login team',
    'teams_member_login_modal.subheader' => 'Log into the team and start managing it.',


    'referrals.title' => 'Referrals',
    'referrals.menu' => 'Referrals',

    'referrals.invite.header' => 'Invite people',
    'referrals.invite.subheader_once' => 'Invite people to %s with the following link and get %s from their first payment to the platform.',
    'referrals.invite.subheader_forever' => 'Invite people to %s with the following link and get %s from all their payments to the platform.',
    'referrals.invite.referral_key' => 'Referral link',
    'referrals.invite.referral_key_help' => 'You can add the %s parameter to any link of our website.',

    'referrals.statistics.header' => 'Statistics',
    'referrals.statistics.referrals' => 'Referrals',
    'referrals.statistics.referrals_help' => 'People who have signed up using your referral link.',
    'referrals.statistics.converted_referrals' => 'Paying referrals',
    'referrals.statistics.converted_referrals_help' => 'People who have signed up & paid for a plan at least once.',
    'referrals.statistics.pending_affiliate_commissions' => 'Pending commissions',
    'referrals.statistics.pending_affiliate_commissions_help' => 'All payments are held for 30 days for proper confirmation before they are approved.',
    'referrals.statistics.approved_affiliate_commissions' => 'Approved commissions',
    'referrals.statistics.approved_affiliate_commissions_help' => 'All payments that have been approved, which are ready to be withdrawn.',

    'referrals.withdraw.header' => 'Withdraw',
    'referrals.withdraw.subheader' => 'Once you reach at least %s, you can create a withdrawal request.',
    'referrals.withdraw.amount' => 'Amount',
    'referrals.withdraw.is_paid_paid' => 'Paid',
    'referrals.withdraw.is_paid_pending' => 'Pending',
    'referrals.withdraw.success_message' => 'Your withdrawal request has been sent for approval and processing.',


    'sso.menu' => 'Go to %s',


    'invoice.title' => 'Invoice %s',
    'invoice.print' => 'Print',
    'invoice.invoice' => 'Invoice',
    'invoice.invoice_nr' => 'Invoice Nr',
    'invoice.invoice_date' => 'Date',
    'invoice.vendor' => 'Vendor',
    'invoice.customer' => 'Customer',
    'invoice.notes' => 'Additional notes',
    'invoice.name' => 'Name',
    'invoice.address' => 'Address',
    'invoice.county' => 'County',
    'invoice.zip' => 'ZIP',
    'invoice.phone' => 'Phone',
    'invoice.tax_id' => 'Tax ID',

    'invoice.item' => 'Item',
    'invoice.amount' => 'Amount',
    'invoice.plan' => '%s Plan',
    'invoice.frequency' => '%s access.',
    'invoice.frequency.monthly' => '30 days',
    'invoice.frequency.quarterly' => '90 days',
    'invoice.frequency.biannual' => '180 days',
    'invoice.frequency.annual' => '1 year',
    'invoice.frequency.lifetime' => 'Lifetime',
    'invoice.code' => 'Discount',
    'invoice.code_help' => 'Code used: %s',
    'invoice.total' => 'Total',
    'invoice.paid_via' => 'Paid via %s',


    'maintenance.title' => 'Maintenance mode',
    'maintenance.header' => 'Maintenance mode',
    'maintenance.subheader' => 'We are doing some maintenance work, we\'ll be back soon.',


    'login.menu' => 'Sign in',
    'login.title' => 'Sign in',
    'login.header' => 'Sign in',
    'login.twofa_token' => 'Two-factor token',
    'login.remember_me' => 'Remember me',
    'login.remember_me_help' => 'A browser cookie will be used to remember you for %s days on this browser.',
    'login.login' => 'Login',
    'login.verify' => 'Verify',
    'login.register' => 'Don\'t have an account? %s',
    'login.register_help' => 'Register',
    'login.lost_password' => 'Lost password',
    'login.resend_activation' => 'Resend activation',
    'login.facebook' => 'Sign in with Facebook',
    'login.google' => 'Sign in with Google',
    'login.twitter' => 'Sign in with X',
    'login.discord' => 'Sign in with Discord',
    'login.linkedin' => 'Sign in with LinkedIn',
    'login.microsoft' => 'Sign in with Microsoft',
    'login.info_message.twofa_token' => 'Two-factor authentication is required.',
    'login.info_message.logged_in' => 'Welcome back, %s.',
    'login.error_message.twofa_token' => 'Your two-factor authentication token is invalid.',
    'login.error_message.wrong_login_credentials' => 'Your login combination is invalid.',
    'login.error_message.user_not_active' => 'Your account is not confirmed or banned.',
    'login.error_message.email_is_null' => 'Your social account doesn\'t have an email associated with it.',


    'lost_password.title' => 'Lost password',
    'lost_password.header' => 'Lost password',
    'lost_password.subheader' => 'We will send you an email with a magic recovery link to reset your password.',
    'lost_password.return' => 'Return to Login',
    'lost_password.submit' => 'Send me a recovery link',
    'lost_password.success_message' => 'We\'ve emailed you the password reset link.',


    'resend_activation.title' => 'Resend activation',
    'resend_activation.header' => 'Resend activation email',
    'resend_activation.subheader' => 'Mails can get lost, but we can send you another activation email for your account.',
    'resend_activation.return' => 'Return to Login',
    'resend_activation.submit' => 'Send me the activation email',
    'resend_activation.success_message' => 'We\'ve emailed you the activation link.',


    'reset_password.title' => 'Set a new password',
    'reset_password.header' => 'Set a new password',
    'reset_password.subheader' => 'For better security, make sure your new password is strong.',
    'reset_password.return' => 'Return to Login',
    'reset_password.new_password' => 'New password',
    'reset_password.repeat_password' => 'Repeat your new password',
    'reset_password.submit' => 'Set password',
    'reset_password.success_message' => 'Your new password is set.',


    'activate_user.user_activation' => 'Your account has been confirmed and is now active.',
    'activate_user.user_pending_email' => 'Your new email address has been confirmed.',


    'register.title' => 'Sign up',
    'register.menu' => 'Sign up',
    'register.header' => 'Sign up',
    'register.repeat_password' => 'Repeat Password',
    'register.accept' => 'I confirm that I have read and understood the %1$s and %2$s of the site.',
    'register.is_newsletter_subscribed' => 'I agree receive a few emails per month from the newsletter. You can unsubscribe at any time.',
    'register.register' => 'Register',
    'register.login' => 'Already have an account? %s',
    'register.login_help' => 'Sign in',
    'register.error_message.name_length' => 'Name must be between 1 and 64 characters.',
    'register.error_message.email_exists' => 'This email address is already in use.',
    'register.error_message.email_aliases_not_allowed' => 'Email aliases are not allowed.',
    'register.error_message.blacklisted_domain' => 'This email domain has been blacklisted.',
    'register.error_message.blacklisted_country' => 'Your country has been blacklisted.',
    'register.success_message.registration' => 'We\'ve emailed you the activation link.',
    'register.success_message.login' => 'Welcome to our platform, we are grateful to have you here.',


    'dashboard.breadcrumb' => 'Dashboard',
    'dashboard.title' => 'Dashboard',
    'dashboard.menu' => 'Dashboard',
    'dashboard.header' => 'Dashboard',
    'dashboard.documents_header' => 'Latest AI documents',
    'dashboard.images_header' => 'Latest AI images',
    'dashboard.transcriptions_header' => 'Latest AI transcriptions',


    'index.breadcrumb' => 'Home',
    'index.menu' => 'Home',
    'index.title' => 'Easy AI Assistant',
    'index.header' => '<span class="text-gradient-primary" style="--gradient-one: var(--pink); --gradient-two: var(--indigo);">Ultimate</span> AI Assistant',
    'index.meta_description' => '',
    'index.meta_keywords' => '',
    'index.subheader' => 'Use AI to help boost your flow & save hours of work. Generate high quality content with our AI.',
    'index.register' => 'Sign up for free',

    'index.feature.one' => '30+ AI types',
    'index.feature.two' => 'No credit card required',
    'index.feature.three' => 'Free trial',

    'index.stats' => 'We\'ve generated more than <span class=\'text-primary-400\'>%1$s documents</span> with our AI systems.',
    'index.images' => '<span class=\'text-primary-400\'>%1$s images</span> generated by our users with AI.',
    'index.images_subheader' => 'Here\'s our latest generated images.',

    'index.widgets.one.header' => 'Choose a tool',
    'index.widgets.one.subheader' => 'Select from a wide array of AI text or AI Image generation tools.',
    'index.widgets.two.header' => 'Generate AI Content',
    'index.widgets.two.subheader' => 'Tell the AI what you need help with and what you want to generate.',
    'index.widgets.three.header' => 'Check & polish',
    'index.widgets.three.subheader' => 'Verify the generated dynamic content and make sure it fits your needs.',

    'index.pricing.header' => '10x your productivity',
    'index.pricing.subheader' => 'Let the AI do the work. Choose the proper plan for your needs.',

    'index.chats' => 'Talk to our AI freely',
    'index.chats.subheader' => 'Ask our chat assistant to help you with any task or question you might have.',
    'index.chats.messages.one' => 'Hi, can you please tell me what does SAAS mean?',
    'index.chats.messages.two' => 'SAAS is an acronym that stands for Software-as-a-Service. It is a software delivery model where a software vendor hosts a software application for their customers online and provides it as a service through the internet. In other words, instead of purchasing and installing software on individual computers or servers, customers pay for access to the software through a subscription, usually on a monthly or annual basis.',
    'index.chats.messages.three' => 'What is the best way to start a SAAS in one paragraph?',
    'index.chats.messages.four' => 'Starting a successful SAAS company requires a clear understanding of what problem your product solves and who your target market is. Begin by validating your idea through market research, surveys, and even a minimum viable product. Once you have a solid understanding of your customers, create a functional prototype and test it extensively, incorporating customer feedback as you go. Determine your pricing, develop a marketing and sales strategy, and build a team with the necessary skills to support your operations, including software development, customer service, and marketing. Finally, ensure that your product is user-friendly, reliable, and scalable, and provide ongoing updates and support to keep your customers satisfied and engaged.',

    'index.transcriptions' => 'AI Speech to Text',
    'index.syntheses' => 'AI Text to Speech',

    'index.testimonials.header' => 'Here\'s what people are saying',
    'index.testimonials.one.text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ornare ex. Vivamus eu ex non orci condimentum placerat ac ac nisi. Nam velit libero, hendrerit vitae auctor eget, congue ut ante.',
    'index.testimonials.one.name' => 'Andrea',
    'index.testimonials.one.attribute' => 'Writer Magazine',
    'index.testimonials.two.text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent finibus vestibulum porta. Sed id eros quam. Nunc at nisi vel arcu placerat gravida.',
    'index.testimonials.two.name' => 'George',
    'index.testimonials.two.attribute' => 'Lorem Ipsum Founder',
    'index.testimonials.three.text' => 'Praesent finibus vestibulum porta. Sed id eros quam. Proin lacinia ipsum porttitor, sollicitudin est in, ornare ex. Vivamus eu ex non orci condimentum placerat ac ac nisi. Nam velit libero, hendrerit vitae auctor eget, congue ut ante.',
    'index.testimonials.three.name' => 'Calvin',
    'index.testimonials.three.attribute' => 'SAAS Lorem Owner',

    'index.faq.header' => '%1$sAnswers%2$s for your common %1$squestions%2$s',
    'index.faq.one.question' => 'How do you edit this?',
    'index.faq.one.answer' => 'All the FAQ section can be edited from the admin panel - languages section.',
    'index.faq.two.question' => 'Lorem ipsum dolor sit amet',
    'index.faq.two.answer' => 'Lorem ipsum dolor sit amet, vim eu quem nonumes omittam. Mutat facete patrioque et est, nusquam abhorreant definiebas te sit, albucius urbanitas pro ad. Ne nemore officiis sed. Cu mundi docendi qui, nam nonumes maluisset constituto an, vix ea solum accusamus consequuntur.',
    'index.faq.three.question' => 'Virtute feugiat ocurreret ad cum',
    'index.faq.three.answer' => 'Virtute feugiat ocurreret ad cum, pro in posse ullum adversarium, te qui stet graece antiopam. Amet omnesque indoctum ut mel, ea eam sonet saperet nostrum. Te modus delectus mel, pri populo definitionem ne, an eam hinc labitur inciderint. Novum vivendum gloriatur ex nec, ad vocibus eleifend deterruisset pro, mutat voluptaria repudiandae eum ea. Ipsum soluta cotidieque sea ut, aliquando scripserit no has, iisque impetus erroribus pro ad. Case labitur scaevola vis ut, clita meliore te eos.',
    'index.faq.four.question' => 'Mel iusto putant feugiat et',
    'index.faq.four.answer' => 'Mel iusto putant feugiat et, qui alii virtute eu. Diceret corrumpit mei an. Ius ei congue iudico, ex quo delectus indoctum. Mnesarchum reprehendunt pro ex, ea vix amet maluisset, in autem omnes consectetuer eum.',

    'index.cta.header' => 'Ready to level up?',
    'index.cta.subheader' => 'Write better, faster & more quality content with the help of our AI.',
    'index.cta.pricing' => 'Pricing',
    'index.cta.register' => 'Sign up',

    'index.blog.header' => 'Latest %1$sblog%2$s posts',


    'api.error_message.no_bearer' => 'The request is missing the Bearer Authentication header.',
    'api.error_message.no_access' => 'You do not have access to the API.',
    'api.error_message.rate_limit' => 'You reached the limit of requests in one minute, please wait.',
    'api.error_message.not_found' => 'The resource you are looking for does not exist.',


    'api_documentation.menu' => 'API Documentation',
    'api_documentation.breadcrumb' => 'API Documentation',
    'api_documentation.title' => 'API Documentation',
    'api_documentation.title_dynamic' => '%s - API Documentation',
    'api_documentation.header' => 'API Documentation',
    'api_documentation.subheader' => 'This is the documentation for the available API endpoints, which are built around the <strong>REST architecture</strong>. All the API endpoints will return a <strong>JSON response</strong> with the standard <strong>HTTP response codes</strong> and need a <strong>Bearer Authentication via an API Key</strong>.',
    'api_documentation.endpoint' => 'Endpoint',
    'api_documentation.example' => 'Example',
    'api_documentation.response' => 'Response example',
    'api_documentation.api_key' => 'API Key',
    'api_documentation.base_url' => 'Base URL',
    'api_documentation.parameters' => 'Parameters',
    'api_documentation.required' => 'Required',
    'api_documentation.optional' => 'Optional',
    'api_documentation.string' => 'String',
    'api_documentation.int' => 'Integer',
    'api_documentation.float' => 'Float',
    'api_documentation.boolean' => 'Boolean',
    'api_documentation.file' => 'File',
    'api_documentation.array' => 'Array',
    'api_documentation.read_all' => 'Retrieve all',
    'api_documentation.read' => 'Retrieve one',
    'api_documentation.create' => 'Create',
    'api_documentation.update' => 'Update',
    'api_documentation.delete' => 'Delete',
    'api_documentation.allowed_values' => 'Allowed values: %s',
    'api_documentation.available_when' => 'Available when: %s',
    'api_documentation.timezone_info' => 'All API endpoint results work with the <strong>%s timezone</strong> unless specified otherwise.',

    'api_documentation.authentication.header' => 'Authentication',
    'api_documentation.authentication.subheader' => 'All the API endpoints require an API key sent by the <strong>Bearer Authentication method.</strong>',

    'api_documentation.filters.page' => 'The page number that you want results from. Defaults to <code>1</code>.',
    'api_documentation.filters.results_per_page' => 'How many results you want per page. Allowed values are: %1$s. Defaults to <code>%2$s</code>.',
    'api_documentation.filters.search' => 'The search string.',
    'api_documentation.filters.search_by' => 'What field are you searching by. Allowed values are: %s.',
    'api_documentation.filters.order_by' => 'What field to order the results by. Allowed values are: %s.',
    'api_documentation.filters.order_by_type' => 'The ordering of the results. Allowed values are: <code>ASC</code> for ascending ordering, and <code>DESC</code> for descending ordering.',

    'api_documentation.team_members' => 'Team members',
    'api_documentation.teams_member' => 'Teams\' member',
    'api_documentation.user' => 'User',


    'contact.breadcrumb' => 'Contact',
    'contact.title' => 'Contact',
    'contact.menu' => 'Contact',
    'contact.header' => 'Contact us',
    'contact.subheader' => 'Get in touch with us via email.',

    'contact.email' => 'Email address',
    'contact.name' => 'Full name',
    'contact.subject' => 'Subject',
    'contact.message' => 'Message',
    'contact.success_message' => 'Your message was sent! We\'ll get back to you shortly.',


    'internal_notifications.breadcrumb' => 'Notifications',
    'internal_notifications.title' => 'Notifications',
    'internal_notifications.menu' => 'Notifications',
    'internal_notifications.header' => 'Notifications',
    'internal_notifications.subheader' => 'All your recent account related notifications.',
    'internal_notifications.no_data' => 'No notifications available',


    'affiliate.breadcrumb' => 'Affiliate',
    'affiliate.title' => 'Affiliate',
    'affiliate.menu' => 'Affiliate',
    'affiliate.header' => 'The affiliates program',
    'affiliate.subheader' => 'Easiest way to earn commission from people that you bring to the platform.',

    'affiliate.commission_percentage.header' => '%s commission',
    'affiliate.commission_percentage.subheader_once' => 'Earn commission from the first payment of any user that you bring to the platform.',
    'affiliate.commission_percentage.subheader_forever' => 'Earn commission from all of the payments of any user that you bring to the platform.',

    'affiliate.minimum_withdrawal_amount.header' => '%s minimum withdrawal',
    'affiliate.minimum_withdrawal_amount.subheader' => 'Once your approved balance reaches the minimum withdrawal amount, you can request a withdrawal.',

    'affiliate.how.header' => 'How does it work?',
    'affiliate.how.one' => 'Sign up',
    'affiliate.how.one_help' => 'Simply register for an account on our platform.',
    'affiliate.how.two' => 'Share your link',
    'affiliate.how.two_help' => 'Start promoting your referral link and bring new users.',
    'affiliate.how.three' => 'Start earning',
    'affiliate.how.three_help' => 'Once your referred users start paying, you\'ll get paid as well.',
    'affiliate.how.four' => 'Withdraw your money',
    'affiliate.how.four_help' => 'Request a withdrawal and you\'ll get paid.',

    'affiliate.cta.header' => 'Start earning money 💰',
    'affiliate.cta.subheader' => 'Create an account and start in just a few minutes.',
    'affiliate.cta.register' => 'Sign up',


    'not_found.title' => 'Not found',
    'not_found.header' => 'Page not found',
    'not_found.subheader' => 'Sorry, we couldn\'t find the page you\'re looking for.',
    'not_found.button' => 'Go back home',


    'documents.breadcrumb' => 'AI Documents',
    'documents.title' => 'AI Documents',
    'documents.menu' => 'AI Documents',
    'documents.header' => 'AI Documents',
    'documents.subheader' => 'Here you can find all the AI generated documents that you have created.',
    'documents.create' => 'Generate AI document',
    'documents.widget.total' => '%s Total documents',
    'documents.widget.words_current_month' => '%s Words used',
    'documents.widget.available_words' => '%s Words available',
    'documents.widget.this_month' => 'This month',
    'documents.table.document' => 'Document',
    'documents.model' => 'AI Model',
    'documents.api_response_time' => 'API Response Time',
    'documents.words' => 'Generated words',
    'documents.words_help' => 'This is an approximation based on the resource usage and language response.',
    'documents.x_words_available' => '%s words available this month',
    'documents.variants' => 'Variants',
    'documents.variants_help' => 'How many results the AI should try to generate.',
    'documents.x_variants' => '%s variants',
    'documents.variant_x' => 'Variant %s',
    'documents.language_help' => 'Tell the AI to give you the answer in the above language.',

    'documents.creativity_level' => 'Creativity level',
    'documents.creativity_level.none' => 'None (most factual)',
    'documents.creativity_level.low' => 'Low (highly factual)',
    'documents.creativity_level.optimal' => 'Optimal',
    'documents.creativity_level.high' => 'High (highly creative)',
    'documents.creativity_level.maximum' => 'Max (most creative)',
    'documents.creativity_level.custom' => 'Custom',
    'documents.creativity_level_help' => 'This tells the AI the amount of creativity "risks" to take when generating content.',
    'documents.creativity_level_custom' => 'Creativity level',
    'documents.creativity_level_custom_help' => '0 is the most factual. 1 is the highest amount of creativity.',
    'documents.input' => 'Input',
    'documents.max_words_per_variant' => 'Maximum words per variant',
    'documents.max_words_per_variant_help' => 'This is an approximation based on the length of the generated words. Leave empty for optimal responses.',
    'documents.content' => 'Content',
    'documents.advanced' => 'Advanced settings',
    'documents.no_data' => 'There are no created AI documents',
    'documents.no_data_help' => 'Start by generating your first AI written document.',
    'documents.error_message.flagged' => 'The keywords/text you\'ve used been flagged as they are breaking the terms of use.',
    'documents.error_message.timed_out' => 'Due to breaking the terms of use, you are timed out for a few minutes.',
    'documents.error_message.prompt_tokens' => 'You\'ve given too much text for the AI to process, please shorten the given text.',


    'document_create.breadcrumb' => 'Create AI document',
    'document_create.title' => 'Create AI document',
    'document_create.header' => 'Create AI document',
    'document_create.name_x' => 'AI Doc - %s',


    'document_update.breadcrumb' => 'Edit AI document',
    'document_update.title' => 'Edit AI document - %s',


    'images.breadcrumb' => 'AI Images',
    'images.title' => 'AI Images',
    'images.menu' => 'AI Images',
    'images.header' => 'AI Images',
    'images.subheader' => 'Here you can find all the AI generated images.',
    'images.create' => 'Generate AI image',
    'images.widget.total' => '%s Total images',
    'images.widget.images_current_month' => '%s Images used',
    'images.widget.available_images' => '%s Images available',
    'images.widget.this_month' => 'This month',
    'images.api' => 'API',
    'images.api_response_time' => 'API Response Time',
    'images.variants' => 'Variants',
    'images.variants_help' => 'How many results the AI should try to generate.',
    'images.x_variants' => '%s variants',
    'images.artist' => 'Artist',
    'images.artist_help' => 'Select the style of the generated image based on specific artists.',
    'images.lighting' => 'Lighting style',
    'images.lighting_help' => 'Select the lighting style of the generated image based on specific light parameters.',
    'images.lighting.warm' => 'Warm',
    'images.lighting.cold' => 'Cold',
    'images.lighting.golden_hour' => 'Golden Hour',
    'images.lighting.blue_hour' => 'Blue Hour',
    'images.lighting.ambient' => 'Ambient',
    'images.lighting.studio' => 'Studio',
    'images.lighting.neon' => 'Neon',
    'images.lighting.dramatic' => 'Dramatic',
    'images.lighting.cinematic' => 'Cinematic',
    'images.lighting.natural' => 'Natural',
    'images.lighting.foggy' => 'Foggy',
    'images.lighting.backlight' => 'Backlight',
    'images.lighting.hard' => 'Hard',
    'images.style' => 'Art style',
    'images.style_help' => 'Select the main style of the generated image based on specific art parameters.',
    'images.style.3d_render' => '3D render',
    'images.style.pixel' => 'Pixel',
    'images.style.sticker' => 'Sticker',
    'images.style.isometric' => 'Isometric',
    'images.style.cyberpunk' => 'Cyberpunk',
    'images.style.vaporwave' => 'Vaporwave',
    'images.style.steampunk' => 'Steampunk',
    'images.style.glitchcore' => 'Glitchcore',
    'images.style.bauhaus' => 'Bauhaus',
    'images.style.vector' => 'Vector',
    'images.style.low_poly' => 'Low poly',
    'images.style.ukiyo_e' => 'Ukiyo-e',
    'images.style.line' => 'Line art',
    'images.style.pencil' => 'Pencil drawing',
    'images.style.ballpoint_pen' => 'Ballpoint pen drawing',
    'images.style.watercolor' => 'Watercolor',
    'images.style.origami' => 'Origami',
    'images.style.cartoon' => 'Cartoon',
    'images.style.retro' => 'Retro',
    'images.style.anime' => 'Anime',
    'images.style.renaissance' => 'Renaissance',
    'images.style.clay' => 'Clay',
    'images.style.cubism' => 'Cubism',
    'images.style.modern' => 'Modern',
    'images.style.pop' => 'Pop',
    'images.style.contemporary' => 'Contemporary',
    'images.style.impressionism' => 'Impressionism',
    'images.style.pointillism' => 'Pointillism',
    'images.style.minimalism' => 'Minimalism',
    'images.mood' => 'Mood',
    'images.mood_help' => 'Select the mood of the generated image.',
    'images.mood.aggressive' => 'Aggressive',
    'images.mood.angry' => 'Angry',
    'images.mood.boring' => 'Boring',
    'images.mood.bright' => 'Bright',
    'images.mood.calm' => 'Calm',
    'images.mood.cheerful' => 'Cheerful',
    'images.mood.chilling' => 'Chilling',
    'images.mood.colorful' => 'Colorful',
    'images.mood.dark' => 'Dark',
    'images.mood.neutral' => 'Neutral',
    'images.size' => 'Image size',
    'images.size_help' => 'The resolution of the generated image.',
    'images.input' => 'Image description',
    'images.input_placeholder' => 'A wide nature scenery with wild life, at the golden hour.',
    'images.input_help' => 'Describe to the AI exactly what you want to generate.',
    'images.content' => 'Content',
    'images.advanced' => 'Advanced settings',
    'images.no_data' => 'There are no created AI images',
    'images.no_data_help' => 'Start by generating your first AI image.',


    'image_create.breadcrumb' => 'Create AI image',
    'image_create.title' => 'Create AI image',
    'image_create.header' => 'Create AI image',
    'image_create.name_x' => 'AI Image - %s',


    'image_update.breadcrumb' => 'Edit AI image',
    'image_update.title' => 'Edit AI image - %s',


    'upscaled_images.breadcrumb' => 'AI Upscaled images',
    'upscaled_images.title' => 'AI Upscaled images',
    'upscaled_images.menu' => 'AI Upscaled images',
    'upscaled_images.header' => 'AI Upscaled images',
    'upscaled_images.subheader' => 'Here you can find all the AI upscaled images.',
    'upscaled_images.create' => 'Upscale image',
    'upscaled_images.api_response_time' => 'API Response Time',
    'upscaled_images.images' => 'Images',
    'upscaled_images.original_image' => 'Original image',
    'upscaled_images.upscaled_image' => 'Upscaled image',
    'upscaled_images.original_size' => 'Original size',
    'upscaled_images.upscaled_size' => 'Upscaled size',
    'upscaled_images.scale' => 'Scale',
    'upscaled_images.scale_help' => 'The maximum output is 4096x4096',
    'upscaled_images.advanced' => 'Advanced settings',
    'upscaled_images.no_data' => 'There are no upscaled images',
    'upscaled_images.no_data_help' => 'Start by creating your first AI upscaled image.',


    'upscaled_image_create.breadcrumb' => 'Upscale Image',
    'upscaled_image_create.title' => 'Upscale Image',
    'upscaled_image_create.header' => 'Upscale Image',
    'upscaled_image_create.name_x' => 'Upscaled Image - %s',


    'upscaled_image_update.breadcrumb' => 'Edit Upscaled Image',
    'upscaled_image_update.title' => 'Edit Upscaled Image - %s',


    'removed_background_images.breadcrumb' => 'AI Removed Background images',
    'removed_background_images.title' => 'AI Removed Background images',
    'removed_background_images.menu' => 'AI Removed Bg. images',
    'removed_background_images.header' => 'AI Removed Background images',
    'removed_background_images.subheader' => 'Here you can find all the AI removed background images.',
    'removed_background_images.create' => 'Remove background',
    'removed_background_images.api_response_time' => 'API Response Time',
    'removed_background_images.images' => 'Images',
    'removed_background_images.original_image' => 'Original image',
    'removed_background_images.removed_background_image' => 'Removed background image',
    'removed_background_images.advanced' => 'Advanced settings',
    'removed_background_images.no_data' => 'There are no cleaned images',
    'removed_background_images.no_data_help' => 'Start by cleaning the background of an image.',


    'removed_background_image_create.breadcrumb' => 'Removed Background Image',
    'removed_background_image_create.title' => 'Removed Background Image',
    'removed_background_image_create.header' => 'Removed Background Image',
    'removed_background_image_create.name_x' => 'Removed Background Image - %s',


    'removed_background_image_update.breadcrumb' => 'Edit Removed Background Image',
    'removed_background_image_update.title' => 'Edit Removed Background Image - %s',


    'replaced_background_images.breadcrumb' => 'AI Replaced Background images',
    'replaced_background_images.title' => 'AI Replaced Background images',
    'replaced_background_images.menu' => 'AI Replaced Bg. images',
    'replaced_background_images.header' => 'AI Replaced Background images',
    'replaced_background_images.subheader' => 'Here you can find all the AI replaced background images.',
    'replaced_background_images.create' => 'Replace background',
    'replaced_background_images.api_response_time' => 'API Response Time',
    'replaced_background_images.images' => 'Images',
    'replaced_background_images.original_image' => 'Original image',
    'replaced_background_images.replaced_background_image' => 'Replaced background image',
    'replaced_background_images.input' => 'New background description',
    'replaced_background_images.input_placeholder' => 'A stunning sunrise at the beach, including palm trees and a summer vibe.',
    'replaced_background_images.input_help' => 'Describe to the AI exactly what you want your new background to be.',
    'replaced_background_images.advanced' => 'Advanced settings',
    'replaced_background_images.no_data' => 'There are no edited images',
    'replaced_background_images.no_data_help' => 'Start by changing the background of an image.',


    'replaced_background_image_create.breadcrumb' => 'Replaced Background Image',
    'replaced_background_image_create.title' => 'Replaced Background Image',
    'replaced_background_image_create.header' => 'Replaced Background Image',
    'replaced_background_image_create.name_x' => 'Replaced Background Image - %s',


    'replaced_background_image_update.breadcrumb' => 'Edit Replaced Background Image',
    'replaced_background_image_update.title' => 'Edit Replaced Background Image - %s',


    'templates.breadcrumb' => 'Templates',
    'templates.title' => 'Templates',
    'templates.menu' => 'Templates',
    'templates.header' => 'Templates',
    'templates.subheader' => 'Here you can find all the available predefined AI document templates.',
    'templates.templates_per_category' => '%s templates',


    'transcriptions.breadcrumb' => 'AI Speech to Text',
    'transcriptions.title' => 'AI Speech to Text',
    'transcriptions.menu' => 'AI Speech to Text',
    'transcriptions.header' => 'AI Speech to Text',
    'transcriptions.subheader' => 'Here you can find all the AI generated transcriptions.',
    'transcriptions.create' => 'Generate AI transcription',
    'transcriptions.widget.total' => '%s Total transcriptions',
    'transcriptions.widget.transcriptions_current_month' => '%s Transcriptions used',
    'transcriptions.widget.available_transcriptions' => '%s Transcriptions available',
    'transcriptions.widget.this_month' => 'This month',
    'transcriptions.transcription' => 'Transcription',
    'transcriptions.words' => 'Transcribed words',
    'transcriptions.api_response_time' => 'API Response Time',
    'transcriptions.file' => 'File',
    'transcriptions.language_help' => 'Help the AI by specifying the language of the speech.',
    'transcriptions.language.auto' => 'Auto detect',
    'transcriptions.input' => 'Audio description',
    'transcriptions.input_placeholder' => 'The transcript is about a two person interaction inside of a cafe bar talking about business ideas, with multiple people speaking in the background.',
    'transcriptions.input_help' => 'Describe the speech from the file uploaded above to help the AI. You can leave this field empty. Must be written in English.',
    'transcriptions.content' => 'Content',
    'transcriptions.advanced' => 'Advanced settings',
    'transcriptions.no_data' => 'There are no created AI transcriptions',
    'transcriptions.no_data_help' => 'Start by generating your first AI transcription.',


    'transcription_create.breadcrumb' => 'Create AI transcription',
    'transcription_create.title' => 'Create AI transcription',
    'transcription_create.header' => 'Create AI transcription',
    'transcription_create.name_x' => 'AI Transcription - %s',


    'transcription_update.breadcrumb' => 'Edit AI transcription',
    'transcription_update.title' => 'Edit AI transcription - %s',


    'chats.breadcrumb' => 'AI Chats',
    'chats.title' => 'AI Chats',
    'chats.menu' => 'AI Chats',
    'chats.header' => 'AI Chats',
    'chats.subheader' => 'Here you can start having conversations with the AI.',
    'chats.create' => 'Start new chat',
    'chats.widget.total' => '%s Total chats',
    'chats.widget.chats_current_month' => '%s Chats used',
    'chats.widget.available_chats' => '%s Chats available',
    'chats.widget.this_month' => 'This month',
    'chats.chat' => 'Chat',
    'chats.chat_assistant_id' => 'Chat assistant',
    'chats.total_messages' => 'Messages',
    'chats.used_tokens' => 'Used tokens',
    'chats.api_response_time' => 'API Response Time',
    'chats.content_placeholder' => 'Ask the bot anything you want...',
    'chats.no_data' => 'There are no created AI chats',
    'chats.no_data_help' => 'Start by talking to your first AI Bot.',


    'chat_create.breadcrumb' => 'Create AI chat',
    'chat_create.title' => 'Create AI chat',
    'chat_create.header' => 'Create AI chat',
    'chat_create.name_x' => 'AI Chat - %s',


    'chat.breadcrumb' => 'AI chat',
    'chat.title' => 'AI Chat - %s',
    'chat.header' => 'AI Chat - %s',
    'chat.total_messages' => '%s chat messages.',
    'chat.error_message.context_length' => 'The chat has reached it\'s context length limit.',
    'chat.error_message.context_length_help' => 'We automatically changed the context length to only remember the last 5 messages. You can resend your message.',


    'chat_settings_modal.header' => 'Chat settings',
    'chat_settings_modal.subheader' => 'We serve ads so we can keep our website running. Please disable your ad blockers.',
    'chat_settings_modal.context_length' => 'Context length',
    'chat_settings_modal.context_length_x' => '%s chat messages',
    'chat_settings_modal.context_length_help' => 'How many of the past messages should the AI remember.',
    'chat_settings_modal.button' => 'Save',


    'syntheses.breadcrumb' => 'AI Text to Speech',
    'syntheses.title' => 'AI Text to Speech',
    'syntheses.menu' => 'AI Text to Speech',
    'syntheses.header' => 'AI Text to Speech',
    'syntheses.subheader' => 'Here you can find all the AI generated syntheses.',
    'syntheses.create' => 'Generate AI synthesis',
    'syntheses.widget.total' => '%s Total syntheses',
    'syntheses.widget.syntheses_current_month' => '%s Syntheses used',
    'syntheses.widget.available_syntheses' => '%s Syntheses available',
    'syntheses.widget.this_month' => 'This month',
    'syntheses.synthesis' => 'Synthesis',
    'syntheses.characters' => 'Characters',
    'syntheses.api_response_time' => 'API Response Time',
    'syntheses.language' => 'Language',
    'syntheses.voice_id' => 'Voice',
    'syntheses.voice_gender' => 'Voice gender',
    'syntheses.voice_gender.male' => 'Male',
    'syntheses.voice_gender.female' => 'Female',
    'syntheses.voice_gender.male_child' => 'Male child',
    'syntheses.voice_gender.female_child' => 'Female child',
    'syntheses.voice_engine' => 'Voice engine',
    'syntheses.voice_engine.standard' => 'Standard',
    'syntheses.voice_engine.neural' => 'Neural (HQ)',
    'syntheses.voice_engine.tts_1' => 'TTS 1',
    'syntheses.voice_engine.tts_1_hd' => 'TTS 1 (HQ)',
    'syntheses.input' => 'Text',
    'syntheses.input_placeholder' => '',
    'syntheses.format' => 'Format',
    'syntheses.input_help' => 'The text that will be used to generate a synthesis with.',
    'syntheses.advanced' => 'Advanced settings',
    'syntheses.no_data' => 'There are no created AI syntheses',
    'syntheses.no_data_help' => 'Start by generating your first AI synthesis.',


    'synthesis_create.breadcrumb' => 'Create AI synthesis',
    'synthesis_create.title' => 'Create AI synthesis',
    'synthesis_create.header' => 'Create AI synthesis',
    'synthesis_create.name_x' => 'AI synthesis - %s',


    'synthesis_update.breadcrumb' => 'Edit AI synthesis',
    'synthesis_update.title' => 'Edit AI synthesis - %s',
];
