## Работа со списком участников СБП

Участники СБП — это банки и платежные сервисы, подключенные к СБП (Система быстрых платежей ЦБ РФ).

SDK позволяет получить актуальный список всех участников СБП.
Список нужно вывести получателю выплаты, идентификатор выбранного участника СБП необходимо использовать в запросе на [создание выплаты](06-payouts.md#Запрос-на-выплату-продавцу).

[Подробнее о выплатах через СБП](https://yookassa.ru/developers/payouts/making-payouts/sbp)

* [Получить список участников СБП](#Получить-список-участников-СБП)

---

### Получить список участников СБП <a name="Получить-список-участников-СБП"></a>

В ответ на запрос вернется список участников СБП. Список будет отсортирован по идентификатору участника в порядке убывания.

Объект участника СБП `SbpParticipantBank` содержит информацию о банке или платежном сервисе, подключенном к СБП.

```php
require_once 'vendor/autoload.php';

$client = new \YooKassa\Client();
$client->setAuth('xxxxxx', 'test_XXXXXXX');

try {
    $result = $client->getSbpBanks();
} catch (\Exception $e) {
    $result = $e;
}

var_dump($result);
```
